<?php

namespace App\Services\Gateway;

use App\Services\Auth;
use App\Models\Paylist;
use App\Services\Config;
use App\Services\View;


class motionpay extends AbstractPayment
{
    
    public function purchase($request, $response, $args) {
        return '';
    }
    public function purchase_maliopay($type, $price, $originHost){
		if($price <= 0){
            return json_encode(['errcode'=>-1,'errmsg'=>"非法的金额."]);
        }
        $user = Auth::getUser();
        // $settings = Config::get("tomatopay")[$type];
        $pl = new Paylist();
        $pl->userid = $user->id;
        $pl->total = $price;
		$pl->tradeno = self::generateGuid();
		$pl->save();
		
        $params = [
            'money' => $price,
            'name' => $_ENV['motionpay_name'],
            'sitename' => $_ENV['appName'],
            'notify_url' => $_ENV['baseUrl'] . '/payment/notify/motionpay',
            'return_url' => $originHost . '/user/payment/return',
            'out_trade_no' => $pl->tradeno,
            'pid' => $_ENV['motionpay_pid'],
            'type'=> $type
        ];
    
        ksort($params);
        reset($params);
        $str = stripslashes(urldecode(http_build_query($params))) . $_ENV['motionpay_key'];
        $params['sign'] = md5($str);
        $params['sign_type'] = 'MD5';
        
        return array('code' => $_ENV['motionpay_url'].http_build_query($params), 'errcode' => 0, 'tradeno' => $pl->tradeno);
	}
	
    public function notify($request, $response, $args){
    }
    
    public function getReturnHTML($request, $response, $args){
      
    }
    public function getPurchaseHTML(){

    }
    public function getStatus($request, $response, $args){
      
    }
    
}