<?php

namespace App\Services\Gateway;

use App\Services\Auth;
use App\Models\Paylist;
use App\Services\Config;
use App\Services\View;

class MotionPay extends AbstractPayment
{
	
	var $apiurl;

	public function __construct(){
		$this->apiurl = 'https://motionpay.net/';
	}

	public function isHTTPS() {
        define('HTTPS', false);
        if (defined('HTTPS') && HTTPS) return true;
        if (!isset($_SERVER)) return FALSE;
        if (!isset($_SERVER['HTTPS'])) return FALSE;
        if ($_SERVER['HTTPS'] === 1) {  //Apache
            return TRUE;
        } elseif ($_SERVER['HTTPS'] === 'on') { //IIS
            return TRUE;
        } elseif ($_SERVER['SERVER_PORT'] == 443) { //其他
            return TRUE;
        }
        return FALSE;
    }

	public function purchase($request, $response, $args) {
    	
		$user = Auth::getUser();
		$type = $request->getParsedBodyParam('type');
        $price = $request->getParam('price');
        $settings = Config::get("motionpay");
        if ($price < $settings['min_price']) {
			$return['ret'] = 0;
			$return['msg'] = "金额低于".$settings['min_price'].'元';
            return json_encode($return);
        }
		
        $pl = new Paylist();
        $pl->userid = $user->id;
        $pl->total = $price;
        $pl->tradeno = self::generateGuid();
        $pl->datetime = time(); // date("Y-m-d H:i:s");
        $pl->save();

        $motionpay_config = array(
            'partner'       => $settings['partner'],
            'key'           => $settings['key'],
            'sign_type'     => strtoupper('MD5'),
            'input_charset' => strtolower('utf-8'),
            'transport'     => 'https',
            'apiurl'        => $settings['apiurl'] ?: $this->apiurl,
        );
		$url_notify = Config::get("baseUrl") . '/payment/notify';  
        $url_return = ($this->isHTTPS() ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'];
		
        /**************************请求参数**************************/
        $out_trade_no = $pl->tradeno;
        $money = (float)$price;
        $parameter = array(
            "pid"          => trim($motionpay_config['partner']),
            "type"         => $type,
            "out_trade_no" => $out_trade_no,
            "notify_url"   => $url_notify,
            "return_url"   => $url_return . "/user/code",
            'name'         => 'U' . $user->id,
            "money"        => $money
        );

        //建立请求
        $motionpay_submit = new MotionPaySDK($motionpay_config);
        //url跳转//data二维码//form表单
        $result = $motionpay_submit->buildRequestForm($parameter, "url");
        //$result = '<script>window.location.href="'.$url.'";</script>';
        $return['ret'] = 1;
        $return['url'] = $result;
        $return['pid'] = $pl->tradeno;
        $return['type'] = $type;
        return json_encode($return);
		
    }
	public function notify($request, $response, $args)
    {
        $out_trade_no = $_GET['out_trade_no'];
        $p = Paylist::where('tradeno', '=', $out_trade_no)->first();
		
        if ($p->status == 1) {
            exit("success 该订单号已完成,请返回来源地重新发起请求");
        }
		$settings = Config::get("motionpay");
        $motionpay_config = array(
            'partner'       => $settings['partner'],
            'key'           => $settings['key'],
            'sign_type'     => strtoupper('MD5'),
            'input_charset' => strtolower('utf-8'),
            'transport'     => 'https',
            'apiurl'        => $settings['apiurl'] ?: $this->apiurl,
        );
		$type = $_GET['type'];
		if (!$type) $type = "MotionPay";
		$trade_status = $_GET['trade_status'];
        //计算得出通知验证结果
        $alipayNotify = new MotionPaySDK($motionpay_config);
        $verify_result = $alipayNotify->verifyNotify();
        if(!$verify_result) exit('fail 签名校验失败!');
		
		if($trade_status=='TRADE_SUCCESS' && $p->status==0){
			$this->postPayment($out_trade_no, $type);
			exit("success");
		}else{
			exit("fail");
		}
    }
	public function getReturnHTML($request, $response, $args)
    {

        $out_trade_no = $_GET['out_trade_no'];
        $p = Paylist::where('tradeno', '=', $out_trade_no)->first();
        $money = $p->total;
		
        if ($p->status == 1) $success = 1;
		$settings = Config::get("motionpay");
        $motionpay_config = array(
            'partner'       => $settings['partner'],
            'key'           => $settings['key'],
            'sign_type'     => strtoupper('MD5'),
            'input_charset' => strtolower('utf-8'),
            'transport'     => 'https',
            'apiurl'        => $settings['apiurl'] ?: $this->apiurl,
        );
		$type = $_GET['type'];
		if (!$type) $type = "MotionPay";
		$trade_status = $_GET['trade_status'];
        //计算得出通知验证结果
        $alipayNotify = new MotionPaySDK($motionpay_config);
        $verify_result = $alipayNotify->verifyNotify();
		if(!$verify_result) $success = 0;
		
		if($trade_status=='TRADE_SUCCESS' && $p->status==0){
			$this->postPayment($out_trade_no, $type);
			$success = 1;
		}else{
			$success = 0;
		}
        return View::getSmarty()->assign('money', $money)->assign('success', $success)->fetch('user/pay_success.tpl');
    }
    public function getPurchaseHTML()
    {
        return '
		<div class="card-inner">
			<p class="card-heading">支付方式:</p>
			<nav class="tab-nav margin-top-no">
				<ul class="nav nav-list">
				    <li class="nav-item">
                        <a class="nav-link waves-attach waves-effect type active" data-toggle="tab" data-pay="alipay"><img src="data:image/svg+xml;base64,CjxzdmcgdmVyc2lvbj0iMS4xIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIiB4PSIwcHgiIHk9IjBweCIgdmlld0JveD0iMCAwIDEwMDAgMTAwMCIgZW5hYmxlLWJhY2tncm91bmQ9Im5ldyAwIDAgMTAwMCAxMDAwIiB4bWw6c3BhY2U9InByZXNlcnZlIj4KPG1ldGFkYXRhPiDnn6Lph4/lm77moIfkuIvovb0gOiBodHRwOi8vd3d3LnNmb250LmNuLyA8L21ldGFkYXRhPjxnPjxwYXRoIGQ9Ik05OTAsNjgwLjlWMTk4LjVDOTkwLDk0LjQsOTA1LjcsMTAsODAxLjUsMTBIMTk4LjVDOTQuNCwxMCwxMCw5NC4zLDEwLDE5OC41djYwMy4xQzEwLDkwNS42LDk0LjMsOTkwLDE5OC41LDk5MGg2MDMuMWM5Mi44LDAsMTY5LjktNjcsMTg1LjUtMTU1LjNjLTUwLTIxLjUtMjY2LjctMTE1LjEtMzc5LjQtMTY5Yy04NS44LDEwNC0xNzUuOCwxNjYuNS0zMTEuMywxNjYuNXMtMjI2LTgzLjMtMjE1LjEtMTg1LjZjNy4xLTY3LjIsNTMuMi0xNzYuNiwyNTMtMTU3LjhjMTA1LjMsMTAsMTUzLjUsMjkuNSwyMzkuNCw1Ny45YzIyLjEtNDAuNyw0MC42LTg1LjUsNTQuNi0xMzMuMkgyNDcuNXYtMzcuN2gxODguM3YtNjcuOEgyMDZ2LTQxLjVoMjI5Ljh2LTk3LjhjMCwwLDIuMi0xNS4zLDE5LTE1LjNoOTQuM3YxMTMuMWgyNDV2NDEuNWgtMjQ1djY3LjhoMTk5LjdjLTE4LjMsNzQuOC00Ni4yLDE0My41LTgxLDIwMy41QzcyNS45LDYwMC4yLDk5MCw2ODAuOSw5OTAsNjgwLjlMOTkwLDY4MC45TDk5MCw2ODAuOXogTTI4MS40LDc2Ny42Yy0xNDMuMywwLTE2NS44LTkwLjUtMTU4LjMtMTI4LjJzNDktODYuNywxMjguNi04Ni43YzkxLjUsMCwxNzMuNSwyMy40LDI3MS44LDcxLjNDNDU0LjUsNzE0LDM2OS41LDc2Ny42LDI4MS40LDc2Ny42TDI4MS40LDc2Ny42eiIgc3R5bGU9ImZpbGw6IzU2YWJlNCI+PC9wYXRoPjwvZz48L3N2Zz4gIA==" height="40"></img></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link waves-attach waves-effect type" data-toggle="tab" data-pay="wxpay"><img src="data:image/svg+xml;base64,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" height="40"></img></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link waves-attach waves-effect type" data-toggle="tab" data-pay="qqpay"><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAABmJLR0QA/wD/AP+gvaeTAAAHVUlEQVRoge2YeVCU5x3HP8+7F+xyiFwSL4hH4nhkTHChBkRGFOloDKM2rbE2STvTTjJN06ROmjZOpmnT6kwznUk702nNpJOjSa0XGjWoiaKYiYApeIQqYkGakIDcsCt7vO/TP4DNAnu9K/5VvzM7s7/f9/ld73M/cAd38P8NMZG+lqxemy008U2gUAgxFcgYplql1FqFUD5CcqTqWNm/ADkhQSfCSW7xuiIJ24EHIjKQXJSK/HV1+cE93GIht1RAfsnGVLfmfhcoii64PGQ0qlvOHD7cHW0OURdgLy69T6AdAqZF62MYTdKgrK4+sr8hGuOoCrCvWpslhPIxvjF+y2jSDJ6lNUeOfKXXUNFrMH/jRrMQyvtMXPIAWYpm2kMUH1R3AbY+zzPA/LF6k8nEtuee5tjud9j23NOYTKaIOB8kD9qL131Xbz4GPY2XL98Y5zWqZYBlLPfEpm/x7dK1WCxm5s7KQlVVai9+Fpbzh4AlS+9f9Fp9fX3EK5OuHhg0u9YBCYG44sJlAPz85e288JsdrBqWR7gRPTCKG4Np/+335OvJyainsRSiNBiXlpoCwMc1nyKE4KWtz4ziSooKkcNLfvpw24AxNFkKVESak64CgHnBiPYbHUyfehd5OdkoQqHtRscormBpjk/258ZB4V49CemdxFODEUdPngbgdy8+zyu/3MrRE6fGcT7ZjxsHGTxGIOjtgcRgxJu79pKRnkZ+rp3Tn1Tx9j/3RcQFQPDxFQC61t2c4nUTcgALg56qoweSIm2stwfGwWr2Ys/qZPGMLqZOusldk5xMsroxGSQ2ixcAh8uIRxX0OM209lj5vNtKXUsS1c3JON1jUpDjl+hQiLgHZB6lj1hX7L0u4kbZ7PphJTOTHXpi+tDUEcd3/po3SpciXdqhwfIncfCG+BRPOB8RbWSygHygfL3aLObIXgYw0SqsSCGoakolIcZNVooDJcLPoWqCY59lsOODBfQNDu3K87QefuC5wovuWgzItZjo+lULZ8P5iiikzONPCJ7y17WJWI4aplFlTOOCMpl4m5clmR1kZ3aSmexgcpybyTYXAF0OC10DZpo7bdQ0JVNzPYXeARNzZS927QYrvV8wR+sdG/aEqGTFxBSQz1kgJxg/KAzUKcnUKilcF3G0KHF0CzNOjKhCYMPLJM1NhnSSKftZqHWR7e0gEXeosJ+LSqaHyy2iSdxqsO1PV505hiCXpxipkqu2k6u2R+IuIvQq5rOELhCIsID1lhV5M+UAj7sbWKl9gSJv32p6TUngddM9VBgybHAwbPuwQyh39cPLpZQnR+RM2c/WwfPcLzsn7kVACKpEKu+aZ1GtpH3dz1Kuqjp28Hgo07BHCSnlDn+5WcQz6PRyvQc6HOD0Rn8rVzPn49z0C5p3nOAnMd+gyj95AEX8NpyPkEPIvvKhbMA+Vm/Fiyahzz30EwJijJD06FMIZx+Gliso3V8i+rsRHheaLRFpS0Sbkol35nzUuxfiWbQMLWkKALGeIMu9JNu+8qHs6uMHz0VVAApPBPQbF8t0s4MBNzg94FLBo8LN0h+jTdZ/03R5vOFyiLIARG4gbYJ0YzJAUuzQT5PglgqOxNSIEh6L/v7+4BmghHyyCTkHBMwNpLfK0V9MEWCJjwdDdEerrp6eoJxEzghlG24SBxycxgDTVprMYVwFx+WGxqCcgJAHrTAFiBt+gjbujx+kNeBVOSLUN1wdq/IPEeL6FnYIyZYRh1KIzcC/AQ4bZ+ASQ+dAaYpBzcji5oZn9eTsw4DDSe2FS/6q+uFYw0WI66HsQ/eAZCfQiZDfqy4ve09I8UeAnaZ7KYhdw9+e3E3X3jZ6/lKHq2hzVAV8eKqSQZfr65CC16rLy94D8RjQKYW2M5S9rs20pKTE0qWZLzA8udNTU/jzq9uxmKMb/y63mx89+zztHZ0jqsZYV+/CioqKwUh96HrYamxsVKfOvqdJIDYBOJxOVFVl8cIFetz48NY/9nCu7rxPFlJsPvNR+WU9PnQ/LVYfPXh4SsLNXSPy/sPlo5KIFDW1dZQdKffJM5Odu88eK/tArx9dQ0geJxGT5R2vpqz56a4HqGlOBsBiNvPyCz9jwbzInnQu1l/mpe2/x+UeOi7bszr5wyPnMCjyfSyuzSKXvttTQIVlP4KHATyqwray+6i4kg6AwWDg0Q2lbFy3BkUJ3LGaprH7wCH+vmc/qqoCkDennVdKz2MxqiPN9okC1/rbU8ApSz8QNyKrmuCNM7N485O78apDSaenprC6qJDFCxaQMSUNgC+/aqf20iXKPzzpe5UzGjQeW/ofHn/wGgZl1MY4IApc8bergH3AuPfRhrYEXq+czZmrqWgytEtFSJbNaef7+deYkx5wpOwVBa4Nkeakfw6YLW8DawPxLV02KhvSqGlO5uqNeEdXv0UAJMe5mJ3Wb12S2cmyuW1Mn+wMFuIAFteW2zYHRiBPmxchxRagEEQWyCQQ3SCbgBMg3xIF7ou3anMHd3AH4fE/Qj7B+Cx0nNsAAAAASUVORK5CYII=" height="40"></img></a>
                    </li>
					<li class="nav-item">
                        <a class="nav-link waves-attach waves-effect type" data-toggle="tab" data-pay="usdtpay"><img src="data:image/png;base64,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" height="40"></img></a>
                    </li>
                </ul>
            </nav>
			<div class="form-group form-group-label">
				<label class="floating-label" for="price">金额</label>
				<input class="form-control" id="price" type="text">
			</div>
			<hr>
			<div class="card-action-btn pull-left">
                <button class="btn btn-primary submit-amounth" id="caipay" >充值</button>
            </div>
		</div>';	
    }
	
    public function getStatus($request, $response, $args)
    {
        $return = [];
        $p = Paylist::where('tradeno', $_POST['pid'])->first();
        $return['ret'] = 1;
        $return['result'] = $p->status;
		$return['msg'] = '等待支付';
        if($p->status == 1){
            $return['msg'] = '订单成功!';
        }
        return json_encode($return);
    }
}
?>