<?php
//码上付接口文件

function motionpay_config() {
    $configarray = array(
     "FriendlyName" => array("Type" => "System", "Value"=>"Motion Pay"),
     "pid" => array("FriendlyName" => "商户ID", "Type" => "text", "Size" => "9", ),
     "key" => array("FriendlyName" => "商户密钥", "Type" => "text", "Size" => "11", ),
    );
    return $configarray;
}

function motionpay_link($params) {

	$_input_charset  = "utf-8";   //字符编码格式 目前支持 GBK 或 utf-8
	$sign_type       = "MD5";     //加密方式 系统默认(不要修改)
	$transport       = $params['transport'];   //访问模式,你可以根据自己的服务器是否支持ssl访问而选择http以及https访问模式(系统默认,不要修改)
	
	# Gateway Specific Variables
	$gatewaySELLER_ID = $params['seller_id'];
	$gatewaySELLER_KEY = $params['key'];
	$gatewayPID = $params['pid'];

	# Invoice Variables
	$invoiceid = $params['invoiceid'];
	$description = $params["description"];
	$amount = $params['amount']; # Format: ##.##

	# System Variables
	$companyname 		= $params['companyname'];
	$systemurl 			= $params['systemurl'];
	$return_url			= $systemurl."/modules/gateways/motionpay/return.php";
	$notify_url			= $systemurl."/modules/gateways/motionpay/notify.php";
	$info = array(					//交易类型
		"return_url"      => $return_url,         				//同步返回
		"notify_url"      => $notify_url,   
		"type"			  => "",    				//支付方式 		
		"subject"         => $companyname."账单@".$invoiceid,        	//商品名称，必填
		"body"            => $description,        				//商品描述，必填
		"out_order_no"    => $invoiceid,      				//商品外部交易号，必填（保证唯一性）
		"total_fee"       => $amount,            				//商品单价，必填（价格不能为0）    						//卖家邮箱，必填
	);

	$epay = new Epayali($info,$gatewayPID,$gatewaySELLER_KEY);
	$code_ajax = $epay->get_code();

	$code = '<div class="alipay" style="max-width: 230px;margin: 0 auto"><div id="alipayimg" style="border: 1px solid #AAA;border-radius: 4px;overflow: hidden;margin-bottom: 5px;"><iframe width="300" height="292" frameborder="0" scrolling="no" style="transform: scale(.9);margin: -50px 0 -24px -37px;"></iframe></div>';
	$code = $code.$code_ajax;
	
	if (stristr($_SERVER['PHP_SELF'], 'viewinvoice')) {
		return $code;
	} else {
		return '<img style="width: 150px" src="'.$systemurl.'/modules/gateways/motionpay/logo.png" alt="开始支付" />';
	}
}



class Epayali {
	//支付接口地址
	const apiurl = 'https://motionpay.net/';
	/**
	 * 支付接口配置信息
	 * @var array
	 */
	private $payment;
	/**
	 * 订单信息
	 * @var array
	 */
	private $order;

	public function __construct($order_info = array(),$partner,$key) {
		$this->order = $order_info;
		$this->payment = array(
			'partner' => $partner,
			'key' => $key,
		);
	}
	/**
	 * 获取支付接口的请求地址
	 *
	 * @return string
	 */
	public function get_code() {
		
		$parameter = array(
			"pid" => trim($this->payment['partner']),
			"out_trade_no"	=> $this->order['out_order_no'],
			"type"	 => "",    				//支付方式 	
			"name"	=> $this->order['subject'],
			"money"	=> $this->order['total_fee'],
			"notify_url"	=> $this->order['notify_url'],
			"return_url"	=> $this->order['return_url'],
			"sitename"	=> 'WHMCS'
		);
		//建立请求
		$html_text = $this->buildRequestForm($parameter, $this->payment['key']);
		return $html_text;
	}
	/**
	 * 通知地址验证
	 * @return bool
	 */
	public function notify_verify() {
		//计算得出通知验证结果
		$Notify = $this->getSignVeryfy($_GET,$_GET['sign']);
		if($Notify) {//验证成功
			if($_GET['trade_status']=='TRADE_SUCCESS'){
				return true;
			}else{
		    	return false;
			}
		}else {
		   //验证失败
		    return false;
		}
	}

	/**
	 * 返回地址验证
	 * @return bool
	 */
	public function return_verify() {
		$Notify = $this->getSignVeryfy($_GET,$_GET['sign']);
		if($Notify) {//验证成功
			if($_GET['trade_status']=='TRADE_SUCCESS'){
				return true;
			}else{
				return false;
			}
		}
		else {
		    //验证失败
		    return false;
		}
	}
	/**
     * 获取返回时的签名验证结果
     * @param $para_temp 通知返回来的参数数组
     * @param $sign 返回的签名结果
     * @return 签名验证结果
     */
	function getSignVeryfy($para_temp, $sign) {
		//除去待签名参数数组中的空值和签名参数
		$para_filter = $this->paraFilter($para_temp);
		
		//对待签名参数数组排序
		$para_sort = $this->argSort($para_filter);
		
		//把数组所有元素，按照“参数=参数值”的模式用“&”字符拼接成字符串
		$prestr = $this->createLinkstring($para_sort);
		
		$isSgin = false;
		$isSgin = $this->md5Verify($prestr, $sign, $this->payment['key']);
	
		return $isSgin;
	}
	/**
	 * 验证签名
	 * @param $prestr 需要签名的字符串
	 * @param $sign 签名结果
	 * @param $key 私钥
	 * return 签名结果
	 */
	public function md5Verify($prestr, $sign, $key) {
		$prestr = $prestr . $key;
		$mysgin = md5($prestr);
		if($mysgin == $sign) {
			return true;
		}else {
			return false;
		}
	}

	/**
	 * 建立请求，以表单HTML形式构造（默认）
	 * @param $para_temp 请求参数数组
	 *
	 */
	public function buildRequestForm($para_temp,$key) {
		//待请求参数数组
		$para = $this->buildRequestPara($para_temp,$key);

		$sHtml = "<form id='paysubmit' name='paysubmit' action='".self::apiurl."submit.php' accept-charset='utf-8' method='POST'>";
		while (list ($key, $val) = each ($para)) {
	        $sHtml.= "<input type='hidden' name='".$key."' value='".$val."'/>";
	    }

		//submit按钮控件请不要含有name属性
	    $sHtml = $sHtml."<input type='submit'  value='支付进行中...' style='display:none;'></form>";
		
		$sHtml = $sHtml."<script>document.forms['paysubmit'].submit();</script>";
		
		return $sHtml;
	}
	/**
	 * 生成要请求给云闪付的参数数组
	 * @param $para_temp 请求前的参数数组
	 * @return 要请求的参数数组
	 */
	public function buildRequestPara($para_temp,$key) {
		//除去待签名参数数组中的空值和签名参数
		$para_filter = $this->paraFilter($para_temp);
		//对待签名参数数组排序
		$para_sort = $this->argSort($para_filter);
		//生成签名结果
		$mysign = $this->buildRequestMysign($para_sort,$key);
		
		//签名结果与签名方式加入请求提交参数组中
		$para_sort['sign'] = $mysign;
		
		return $para_sort;
	}
	/**
	 * 除去数组中的空值和签名参数
	 * @param $para 签名参数组
	 * return 去掉空值与签名参数后的新签名参数组
	 */
	public function paraFilter($para) {
		$para_filter = array();
		while (list ($key, $val) = each ($para)) {
			if($key == "sign" || $key == "sign_type" || $val == "")continue;
			else	$para_filter[$key] = $para[$key];
		}
		return $para_filter;
	}
	/**
	 * 对数组排序
	 * @param $para 排序前的数组
	 * return 排序后的数组
	 */
	public function argSort($para) {
		ksort($para);
		reset($para);
		return $para;
	}
	/**
	 * 生成签名结果
	 * @param $para_sort 已排序要签名的数组
	 * return 签名结果字符串
	 */
	public function buildRequestMysign($para_sort,$key) {
		//把数组所有元素，按照“参数=参数值”的模式用“&”字符拼接成字符串
		$prestr = $this->createLinkstring($para_sort);
		$mysign = $this->md5Sign($prestr, $key);
		return $mysign;
	}
	public function md5Sign($prestr, $key) {
		$prestr = $prestr . $key;
		return md5($prestr);
	}
	/**
	 * 把数组所有元素，按照“参数=参数值”的模式用“&”字符拼接成字符串
	 * @param $para 需要拼接的数组
	 * return 拼接完成以后的字符串
	 */
	public function createLinkstring($para) {
		$arg  = "";
		while (list ($key, $val) = each ($para)) {
			$arg.=$key."=".$val."&";
		}
		//去掉最后一个&字符
		$arg = substr($arg,0,count($arg)-2);
		
		//如果存在转义字符，那么去掉转义
		if(get_magic_quotes_gpc()){$arg = stripslashes($arg);}
		
		return $arg;
	}

}









?>